"""
/mnt/data/by/00/envs/caption_metric/bin/python /home/baiy/Projects/00/CounterintuitiveBench/scripts/diff_violation_type_acc.py
"""

from tqdm import tqdm 
import json
from nltk.translate.bleu_score import sentence_bleu, SmoothingFunction
from nltk.translate.meteor_score import meteor_score
from rouge_score import rouge_scorer
from bert_score import score
import nltk
import copy

from transformers import logging
logging.set_verbosity_error()


from nltk.tokenize import word_tokenize


def _load_img_label(json_file_path):
    """Loads labels from the json file."""
    with open(json_file_path, 'r', newline='', encoding='utf-8') as jsonfile:
        contrasense_json = json.load(jsonfile)
    return contrasense_json

def read_txt_lines(file_path, encoding='utf-8'):
    """
    按行读取 .txt 文件内容，返回为字符串列表。

    Args:
        file_path (str): 文本文件路径
        encoding (str): 文本编码格式，默认 'utf-8'

    Returns:
        list of str: 每一行为一个字符串元素的列表
    """
    try:
        with open(file_path, 'r', encoding=encoding) as f:
            lines = [line.strip().split('\t') for line in f if line.strip()]
        print(f"Read file success：{file_path}")
        return lines
    except Exception as e:
        print(f"Read TXT file fail：{e}")
        return None

def get_violation_type_id(data, five_violation_type_dict):
    datas = data[1: ]
    for id_anno in datas:
        _id = id_anno[0]
        if id_anno[1] == "1":
            five_violation_type_dict["Context Violation"].append(_id)
        if id_anno[2] == "1":
            five_violation_type_dict["Attribute Violation"].append(_id)
        if id_anno[3] == "1":
            five_violation_type_dict["Size/Proportion Anomalies"].append(_id)
        if id_anno[4] == "1":
            five_violation_type_dict["Physics-Impossible"].append(_id)
        if id_anno[5] == "1":
            five_violation_type_dict["Function/State Perversity"].append(_id)
    return five_violation_type_dict

def read_log_file(file_path, encoding='utf-8'):
    """
    读取日志文件内容

    参数:
        file_path (str): 日志文件路径
        encoding (str, optional): 文件编码，默认为'utf-8'

    返回:
        str: 日志文件内容，如果出错返回None
    """
    try:
        with open(file_path, 'r', encoding=encoding) as file:
            return file.read()
    except FileNotFoundError:
        print(f"错误: 文件 '{file_path}' 不存在")
        return None
    except PermissionError:
        print(f"错误: 没有权限读取文件 '{file_path}'")
        return None
    except UnicodeDecodeError:
        print(f"错误: 使用 {encoding} 编码读取文件时发生解码错误")
        return None
    except Exception as e:
        print(f"未知错误: {e}")
        return None

def lmlk(label_json, img_id):
    label = label_json[img_id]["questions"]
    for key in label.keys():
        if "object class Question" in key:
            object_class_Question_ans = label[key]["correct answer"]
        elif "object colour Question" in key:
            object_colour_Question_ans = label[key]["correct answer"]
        elif "object num Question" in key:
            object_num_Question_ans = label[key]["correct answer"]
        elif "is counterintuitive Question" in key:
            is_counterintuitive_Question_ans = label[key]["correct answer"]
        elif "relation Question" in key:
            relation_Question_ans = label[key]["correct answer"]
        elif "Anomaly Recognition Question (Higher Order)" in key:
            Anomaly_Recognition_Question_ans = label[key]["correct answer"]
    answer_label = [object_class_Question_ans, object_colour_Question_ans, object_num_Question_ans, is_counterintuitive_Question_ans, relation_Question_ans, Anomaly_Recognition_Question_ans]

def get_answer_and_label(predict):
    answer = [
        predict["object_class_answer_option"], 
        predict["object_colour_answer_option"], 
        predict["object_num_answer_option"], 
        predict["counterintuitive_answer_option"], 
        predict["relation_answer_option"], 
        predict["Anomaly_Recognition_answer_option"]
        ]
    label = [
        predict["object_class_label_option"], 
        predict["object_colour_label_option"], 
        predict["object_num_label_option"], 
        predict["counterintuitive_label_option"], 
        predict["relation_label_option"], 
        predict["Anomaly_Recognition_label_option"]
        ]
    return answer, label

def write_performence(performence, P, R, F1, bleu1, bleu2, bleu4, meteor, scores):
    # --- BERTScore ---
    performence["BERTScore"]["Precision"].append(P.item())
    performence["BERTScore"]["Recall"].append(R.item())
    performence["BERTScore"]["F1"].append(F1.item())

    # --- BLEU ---
    performence["BLEU"]["BLEU-1"].append(bleu1)
    performence["BLEU"]["BLEU-2"].append(bleu2)
    performence["BLEU"]["BLEU-4"].append(bleu4)

    # --- METEOR ---
    performence["METEOR"].append(meteor)

    # --- ROUGE ---
    for key in scores:
        performence["ROUGE"][key.upper()]["Precision"].append(scores[key].precision)
        performence["ROUGE"][key.upper()]["Recall"].append(scores[key].recall)
        performence["ROUGE"][key.upper()]["F1"].append(scores[key].fmeasure)

def evaluate_captions(predict: str, label: str):

    # --- BERTScore ---
    P, R, F1 = score([predict], [label], lang='en', verbose=False)

    # --- BLEU ---
    ref_tokens = label.split()
    pred_tokens = predict.split()
    smoothie = SmoothingFunction().method4
    bleu1 = sentence_bleu([ref_tokens], pred_tokens, weights=(1, 0, 0, 0), smoothing_function=smoothie)
    bleu2 = sentence_bleu([ref_tokens], pred_tokens, weights=(0.5, 0.5, 0, 0), smoothing_function=smoothie)
    bleu4 = sentence_bleu([ref_tokens], pred_tokens, weights=(0.25, 0.25, 0.25, 0.25), smoothing_function=smoothie)

    # --- METEOR ---
    meteor = meteor_score([word_tokenize(label)], word_tokenize(predict))

    # --- ROUGE ---
    scorer = rouge_scorer.RougeScorer(['rouge1', 'rouge2', 'rougeL'], use_stemmer=True)
    scores = scorer.score(label, predict)

    return P, R, F1, bleu1, bleu2, bleu4, meteor, scores

def print_performance(performence):
    BERTScore_Precision = sum(performence["BERTScore"]["Precision"]) / len(performence["BERTScore"]["Precision"])
    BERTScore_Recall = sum(performence["BERTScore"]["Recall"]) / len(performence["BERTScore"]["Recall"])
    BERTScore_F1 = sum(performence["BERTScore"]["F1"]) / len(performence["BERTScore"]["F1"])

    print("BERTScore:")
    print(f"  Precision: {BERTScore_Precision}")
    print(f"  Recall:    {BERTScore_Recall}")
    print(f"  F1:        {BERTScore_F1}\n")

    BLUE_1 = sum(performence["BLEU"]["BLEU-1"]) / len(performence["BLEU"]["BLEU-1"])
    BLUE_2 = sum(performence["BLEU"]["BLEU-2"]) / len(performence["BLEU"]["BLEU-2"])
    BLUE_4 = sum(performence["BLEU"]["BLEU-4"]) / len(performence["BLEU"]["BLEU-4"])

    print("BLEU:")
    print(f"  BLEU-1: {BLUE_1}")
    print(f"  BLEU-2: {BLUE_2}")
    print(f"  BLEU-4: {BLUE_4}\n")

    METEOR = sum(performence["METEOR"]) / len(performence["METEOR"])

    print(f"METEOR: {METEOR}\n")

    print("ROUGE:")
    for key in performence["ROUGE"].keys():
        Precision = sum(performence["ROUGE"][key]["Precision"]) / len(performence["ROUGE"][key]["Precision"])
        Recall = sum(performence["ROUGE"][key]["Recall"]) / len(performence["ROUGE"][key]["Recall"])
        F1 = sum(performence["ROUGE"][key]["F1"]) / len(performence["ROUGE"][key]["F1"])
        print(f"  {key.upper()}: Precision={Precision}, Recall={Recall}, F1={F1}")
    
    print(f'total num: {len(performence["METEOR"])}')

def main():
    txt_file_path = r"/home/baiy/Projects/00/CounterintuitiveBench/ContraSense/six_violation_type_distribution.txt"
    label_json_path = r'/home/baiy/Projects/00/CounterintuitiveBench/ContraSense/contrasense_QA.json'

    DeepSeek_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-26 20:49_contrasense_DeepSeek-VL-7B-Chat_data.log"
    llama_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-26 22:16_contrasense_Llama-3.2-11B-Vision-Instruct_data.log"
    qwen_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-26 22:47_contrasense_Qwen2_5-VL-7B-Instruct_data.log"    # 1
    llava_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-26 23:38_contrasense_LLaVA-NeXT-8B_data.log"    # 1
    gpt4o_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-27 01:24_contrasense_GPT-4o_data.log"
    gemini_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-28 18:59_contrasense_Gemini_data.log"
    gemini2_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-28 19:00_contrasense_Gemini-2.0-Pro_data.log"
    gpt41_log_file = r"/home/baiy/Projects/00/CounterintuitiveBench/evaluation_logs/contrasense/2025-05-29 11:02_contrasense_GPT-4.1_data.log"

    curr_log_file = gpt41_log_file
    data = read_txt_lines(txt_file_path)
    
    five_violation_type_dict = {
        "Context Violation": [],
        "Attribute Violation": [],
        "Size/Proportion Anomalies": [],
        "Physics-Impossible": [],
        "Function/State Perversity": [],
    }

    five_violation_type_correct_num = {
        "Context Violation": 0,             # 313
        "Attribute Violation": 0,           # 399
        "Size/Proportion Anomalies": 0,     # 267
        "Physics-Impossible": 0,            # 424
        "Function/State Perversity": 0,     # 110
    }   	

    performence = {
        "BERTScore": {
            "Precision": [],
            "Recall": [],
            "F1": []
        },
        "BLEU": {
            "BLEU-1": [],
            "BLEU-2": [],
            "BLEU-4": []
        },
        "METEOR": [],
        "ROUGE": {
            "ROUGE1": {
                "Precision": [],
                "Recall": [],
                "F1": []
            },
            "ROUGE2": {
                "Precision": [],
                "Recall": [],
                "F1": []
            },
            "ROUGEL": {
                "Precision": [],
                "Recall": [],
                "F1": []
            }
        }
    }

    Context_perf = copy.deepcopy(performence)
    Attribute_perf = copy.deepcopy(performence)
    Size_perf = copy.deepcopy(performence)
    Physics_perf = copy.deepcopy(performence)
    Function_perf = copy.deepcopy(performence)

    five_violation_type_dict = get_violation_type_id(data, five_violation_type_dict)

    log_file = read_log_file(curr_log_file)
    log_file_answer = log_file.split("\n")
    log_file_answer_dict = eval(log_file_answer[-3][len("2025-05-27 07:01:49,692 - INFO - "): ])

    label_json = _load_img_label(label_json_path)

    for img_id in tqdm(log_file_answer_dict.keys()):
        predict = log_file_answer_dict[img_id]
        caption_predict = predict["caption_answer"]
        if type(caption_predict) == list:
            caption_predict = caption_predict[0]
        # caption_label = predict["caption_label"]
        caption_label = label_json[img_id]['caption']

        P, R, F1, bleu1, bleu2, bleu4, meteor, scores = evaluate_captions(caption_predict, caption_label)

        if img_id in five_violation_type_dict["Context Violation"]:
            write_performence(Context_perf, P, R, F1, bleu1, bleu2, bleu4, meteor, scores)
        if img_id in five_violation_type_dict["Attribute Violation"]:
            write_performence(Attribute_perf, P, R, F1, bleu1, bleu2, bleu4, meteor, scores)
        if img_id in five_violation_type_dict["Size/Proportion Anomalies"]:
            write_performence(Size_perf, P, R, F1, bleu1, bleu2, bleu4, meteor, scores)
        if img_id in five_violation_type_dict["Physics-Impossible"]:
            write_performence(Physics_perf, P, R, F1, bleu1, bleu2, bleu4, meteor, scores)
        if img_id in five_violation_type_dict["Function/State Perversity"]:
            write_performence(Function_perf, P, R, F1, bleu1, bleu2, bleu4, meteor, scores)

    print(f"--- Context Violation:")
    print_performance(Context_perf)

    print(f"--- Attribute Violation:")
    print_performance(Attribute_perf)

    print(f"--- Size/Proportion Anomalies:")
    print_performance(Size_perf)

    print(f"--- Physics-Impossible:")
    print_performance(Physics_perf)

    print(f"--- Function/State Perversity:")
    print_performance(Function_perf)
    


        # answer, label = get_answer_and_label(predict)
        # if answer == label:
        #     if img_id in five_violation_type_dict["Context Violation"]:
        #         five_violation_type_correct_num["Context Violation"] += 1
        #     if img_id in five_violation_type_dict["Attribute Violation"]:
        #         five_violation_type_correct_num["Attribute Violation"] += 1
        #     if img_id in five_violation_type_dict["Size/Proportion Anomalies"]:
        #         five_violation_type_correct_num["Size/Proportion Anomalies"] += 1
        #     if img_id in five_violation_type_dict["Physics-Impossible"]:
        #         five_violation_type_correct_num["Physics-Impossible"] += 1
        #     if img_id in five_violation_type_dict["Function/State Perversity"]:
        #         five_violation_type_correct_num["Function/State Perversity"] += 1
    
    # print(f'\n- {curr_log_file}')
    # print(f"- Context Violation: {five_violation_type_correct_num['Context Violation']}/313 | {five_violation_type_correct_num['Context Violation']/313}")
    # print(f"- Attribute Violation: {five_violation_type_correct_num['Attribute Violation']}/399 | {five_violation_type_correct_num['Attribute Violation']/399}")
    # print(f"- Size/Proportion Anomalies: {five_violation_type_correct_num['Size/Proportion Anomalies']}/267 | {five_violation_type_correct_num['Size/Proportion Anomalies']/267}")
    # print(f"- Physics-Impossible: {five_violation_type_correct_num['Physics-Impossible']}/424 | {five_violation_type_correct_num['Physics-Impossible']/424}")
    # print(f"- Function/State Perversity: {five_violation_type_correct_num['Function/State Perversity']}/110 | {five_violation_type_correct_num['Function/State Perversity']/110}\n")




if __name__ == "__main__":
    main()