import torch
import argparse
from scripts.utils import load_module_keys


def create_arg_parser():

    parser = argparse.ArgumentParser(description="Detection Model Parameters")

    # OOD Detector and Dataset parameters
    parser.add_argument(
        '--DATASET_PATH',
        type=dict,
        default={
            'contrasense': r'path_to_ContraSense',
            },
        help='all dataset path'
        )
    parser.add_argument(
        '--DATASET_LABEL',
        type=dict,
        default={
            'contrasense': r'../contrasense_QA.json',
            },
        help='dataset path'
        )
    parser.add_argument(
        '--dataset_path',
        type=str,
        default=None,
        help='dataset path'
        )
    parser.add_argument(
        '--model_para_path',
        type=str,
        default=None,
        help='model parameter path'
        )
    parser.add_argument(
        '--model_config',
        type=str,
        default=r'../model_config.json',
        help='Path to the model configuration JSON file.'
    )
    parser.add_argument(
        "--log_dir",
        type=str,
        default=r"../evaluation_logs",
        help="Directory where logs will be stored. Default is './logs'."
    )
    parser.add_argument(
        '--dataset', 
        type=str, 
        default='contrasense', 
        choices=['contrasense'], 
        help='Currently selected dataset'
        )
    parser.add_argument(
        '--batchsize', 
        type=int, 
        default=1, 
        help='Batch size for ood detection. The number of samples processed together in one forward pass.'
        )
    parser.add_argument(
        '--eval_model', 
        type=str, 
        default=None,
        choices=load_module_keys(r'../model_config.json'), 
        help='The model to be used for evaluation. Choose from the available models based on the task requirements.'
    )
    parser.add_argument(
        "--module", 
        type=str,  
        help="Specify the module to use, like meta-llama/Llama-3.2-11B-Vision-Instruct"
    )
    parser.add_argument(
        "--contra_metric_correct_num",
        type=int,
        default=0,
        help="contrasense correct num."
    )
    parser.add_argument(
        "--caption_instruction",
        type=str,
        default="Please describe the image. Identify the main object categories present, specify the attributes (e.g., color) of each category, and explain the spatial or semantic relationships between them."
    )
    parser.add_argument(
        "--img_size",
        type=int,
        default=64,
        help="Image size."
    )

    # choice device
    parser.add_argument(
        '--device', 
        type=str, 
        default='cuda' if torch.cuda.is_available() else 'cpu', 
        choices=['cuda', 'cpu'], 
        help='Device to run the model on'
        )
    parser.add_argument(
        "--nproc_per_node",
        type=int,
        default=1,
        help="Number of processes per node (GPUs per node)."
    )
    parser.add_argument(
        "--master_port",
        type=int,
        default=10000,
        help="Master port for distributed training."
    )
    parser.add_argument(
        '--local_rank',
        type=int, 
        default=-1, 
        help='Local rank for distributed training'
        )
    parser.add_argument(
        '--local-rank',
        type=int, 
        default=-1, 
        help='Local rank for distributed training'
        )
    parser.add_argument(
        '--cuda_devices', 
        type=str, 
        default='0',
        help='Comma separated list of GPU ids to use, e.g., "0,1" for GPU 0 and 1. Default is "0".'
    )
    parser.add_argument(
        "--ddp", 
        action="store_true", 
        help="Enable Distributed Data Parallel (DDP)"
        )
    parser.add_argument(
        '--use_deepspeed', 
        action='store_true',
        default=False, 
        help='Whether to use DeepSpeed for model inference. Default is False.'
    )

    parser.add_argument(
        "--timestamp", 
        type=str, 
        default=None, 
        help="Current timestamp in format YYYY-MM-DD HH:MM (default: None)"
        )
    parser.add_argument(
        "--store_tensor_path",
        type=str,
        default=r'',
        help='Specify the path to store tensors. If no other path is provided, the program will use this default path to store tensor data.'
    )

    return parser
