import glob
import os
import random



def find_jpg_files(directory):
    jpg_files = []
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.jpg'):
                jpg_files.append(os.path.relpath(os.path.join(root, file), directory))
    return jpg_files

# 指定文件夹路径
folder_path = '/media/yss/c99bff0d-4510-4d41-aa46-4c6cb2dc274d/datasets/Vkitti2/RGB/Scene18/' #SUNRGBDv2Test

# 查找所有后缀为.jpg的文件
jpg_files = find_jpg_files(folder_path)
# RGB:'overcast/frames/rgb/Camera_0/rgb_00064.jpg'  Depth:'overcast/frames/depth/Camera_0/depth_00120.png'
# 将文件路径写入txt文件
txt_file_path = '/home/yss/桌面/code-master/Focus/train_test_inputs/vkitti2_test_files_with_gt.txt'
total = len(jpg_files)
sample_num = 500
random_numbers = random.sample(range(0, total-1), sample_num)
with open(txt_file_path, 'w') as file:
    for i in range(sample_num):
        idx = random_numbers[i]
        jpg_file = jpg_files[idx]
        png_seg = jpg_file.split('/')
        if png_seg[0]=='rain':
            continue
        if png_seg[0]=='fog':
            continue
        
        name =  png_seg[4].split('.')[0].split('_')[1:]
        png_name = 'depth' + '_' + name[0] + '.png'       # 2015-11-13T14.52.56.266-0000000282.jpg
        png_file = png_seg[0] + '/' + png_seg[1] + '/' + 'depth' + '/' + png_seg[3] + '/' + png_name
        file.write(jpg_file + ' ' + png_file + '\n')

print("文件路径已写入txt文件:", txt_file_path)