import glob
import os
import random

def find_jpg_files(directory):
    jpg_files = []
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.jpg'):
                jpg_files.append(os.path.relpath(os.path.join(root, file), directory))
    return jpg_files

# 指定文件夹路径
folder_path = '/media/yss/c99bff0d-4510-4d41-aa46-4c6cb2dc274d/datasets/SUNRGBDv2Test/' #SUNRGBDv2Test

# 查找所有后缀为.jpg的文件
jpg_files = find_jpg_files(folder_path)
total = len(jpg_files)
sample_num = 200
random_numbers = random.sample(range(0, total-1), sample_num)
# 将文件路径写入txt文件
txt_file_path = '/home/yss/桌面/code-master/Focus/train_test_inputs/sunrgbd_test_files_with_gt.txt'
with open(txt_file_path, 'w') as file:
    for i in range(sample_num):
        idx = random_numbers[i]
        jpg_file = jpg_files[idx]
        png_seg = jpg_file.split('/')
        name =  png_seg[3].split('.')
        png_name = name[0] + '.' + name[1] + '.' + name[2] + '.' + name[3]  + '.png'       # 2015-11-13T14.52.56.266-0000000282.jpg
        png_file = png_seg[0] + '/' + png_seg[1] + '/' + 'depth' + '/' + png_name
        file.write(jpg_file + ' ' + png_file + '\n')

print("文件路径已写入txt文件:", txt_file_path)