import glob
import os
import random

def find_jpg_files(directory):
    jpg_files = []
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.png'):
                jpg_files.append(os.path.relpath(os.path.join(root, file), directory))
    return jpg_files

# 指定文件夹路径
folder_path = '/media/yss/c99bff0d-4510-4d41-aa46-4c6cb2dc274d/datasets/DIODE/val/outdoor/' #indoors

# 查找所有后缀为.jpg的文件
jpg_files = find_jpg_files(folder_path)
total = len(jpg_files)
#sample_num = 200
#random_numbers = random.sample(range(0, total-1), sample_num)
# 将文件路径写入txt文件
txt_file_path = '/home/yss/桌面/code-master/Focus/train_test_inputs/diode_outdoor_test_files_with_gt.txt'
with open(txt_file_path, 'w') as file:
    for jpg_file in jpg_files:
        npy_seg = jpg_file.split('.') # scene_00021/scan_00191/00021_00191_indoors_230_030.png
        depth = npy_seg[0] + '_depth.npy'
        mask = npy_seg[0] + '_depth_mask.npy'
        file.write(jpg_file + ' ' + depth + ' ' + mask + '\n')

print("文件路径已写入txt文件:", txt_file_path)