import argparse
import json
from utils.easydict import EasyDict as edict
from utils.easydict import get_model_config




config_file = './configs/DME/config_4expert.json'
with open(config_file, "r") as f:
    config = edict(json.load(f))

# handle dictionary inheritance
# only training config is supported for inheritance
if "inherit" in config.train and config.train.inherit is not None:
    inherit_config = get_model_config(config.train["inherit"]).train
    for key, value in inherit_config.items():
        if key not in config.train:
            config.train[key] = value


print('done')